import os
from dotenv import load_dotenv
import mysql.connector

load_dotenv('/home/startoir/beh-gram.ir/ai_bot/bot/.env')

print("Testing database connection...")
print(f"DB_HOST: {os.getenv('DB_HOST')}")
print(f"DB_USER: {os.getenv('DB_USER')}")
print(f"DB_NAME: {os.getenv('DB_NAME')}")

try:
    conn = mysql.connector.connect(
        host=os.getenv('DB_HOST'),
        user=os.getenv('DB_USER'),
        password=os.getenv('DB_PASSWORD'),
        database=os.getenv('DB_NAME')
    )
    print("✓ Database connection successful!")
    conn.close()
except Exception as e:
    print(f"✗ Database error: {e}")