#!/usr/bin/env python3
"""
اسکریپت ایجاد ادمین اولیه
استفاده: python create_admin.py
"""

import mysql.connector
import hashlib
import getpass
from dotenv import load_dotenv
import os

load_dotenv()

def hash_password(password):
    return hashlib.sha256(password.encode()).hexdigest()

def create_admin():
    print("=" * 50)
    print("🔐 ایجاد ادمین جدید")
    print("=" * 50)
    
    # دریافت اطلاعات
    username = input("نام کاربری: ")
    email = input("ایمیل: ")
    full_name = input("نام کامل: ")
    password = getpass.getpass("رمز عبور: ")
    password_confirm = getpass.getpass("تکرار رمز عبور: ")
    
    if password != password_confirm:
        print("❌ رمز عبور و تکرار آن یکسان نیستند!")
        return
    
    # انتخاب نقش
    print("\nنقش ادمین:")
    print("1. Super Admin (دسترسی کامل)")
    print("2. Admin (دسترسی مدیریتی)")
    print("3. Moderator (مدیریت محتوا)")
    print("4. Viewer (فقط مشاهده)")
    
    role_choice = input("انتخاب کنید (1-4): ")
    role_map = {
        '1': 'super_admin',
        '2': 'admin',
        '3': 'moderator',
        '4': 'viewer'
    }
    role = role_map.get(role_choice, 'moderator')
    
    # تعیین مجوزها
    if role == 'super_admin':
        permissions = {
            'can_manage_users': True,
            'can_manage_prompts': True,
            'can_manage_buttons': True,
            'can_view_analytics': True,
            'can_manage_admins': True,
            'can_manage_settings': True
        }
    elif role == 'admin':
        permissions = {
            'can_manage_users': True,
            'can_manage_prompts': True,
            'can_manage_buttons': True,
            'can_view_analytics': True,
            'can_manage_admins': False,
            'can_manage_settings': True
        }
    elif role == 'moderator':
        permissions = {
            'can_manage_users': False,
            'can_manage_prompts': True,
            'can_manage_buttons': True,
            'can_view_analytics': True,
            'can_manage_admins': False,
            'can_manage_settings': False
        }
    else:  # viewer
        permissions = {
            'can_manage_users': False,
            'can_manage_prompts': False,
            'can_manage_buttons': False,
            'can_view_analytics': True,
            'can_manage_admins': False,
            'can_manage_settings': False
        }
    
    # اتصال به دیتابیس
    try:
        conn = mysql.connector.connect(
            host=os.getenv('DB_HOST', 'localhost'),
            user=os.getenv('DB_USER'),
            password=os.getenv('DB_PASSWORD'),
            database=os.getenv('DB_NAME')
        )
        cursor = conn.cursor()
        
        # بررسی وجود نام کاربری
        cursor.execute("SELECT id FROM admins WHERE username = %s", (username,))
        if cursor.fetchone():
            print(f"❌ نام کاربری '{username}' قبلاً وجود دارد!")
            return
        
        # ایجاد ادمین
        password_hash = hash_password(password)
        
        query = """
            INSERT INTO admins 
            (username, email, password_hash, full_name, role,
             can_manage_users, can_manage_prompts, can_manage_buttons,
             can_view_analytics, can_manage_admins, can_manage_settings,
             is_active)
            VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, TRUE)
        """
        
        cursor.execute(query, (
            username,
            email,
            password_hash,
            full_name,
            role,
            permissions['can_manage_users'],
            permissions['can_manage_prompts'],
            permissions['can_manage_buttons'],
            permissions['can_view_analytics'],
            permissions['can_manage_admins'],
            permissions['can_manage_settings']
        ))
        
        conn.commit()
        admin_id = cursor.lastrowid
        
        print("\n" + "=" * 50)
        print("✅ ادمین با موفقیت ایجاد شد!")
        print("=" * 50)
        print(f"ID: {admin_id}")
        print(f"نام کاربری: {username}")
        print(f"ایمیل: {email}")
        print(f"نقش: {role}")
        print("\nمجوزها:")
        for perm, value in permissions.items():
            print(f"  - {perm}: {'✓' if value else '✗'}")
        print("=" * 50)
        
        cursor.close()
        conn.close()
        
    except mysql.connector.Error as err:
        print(f"❌ خطا در اتصال به دیتابیس: {err}")
    except Exception as e:
        print(f"❌ خطای غیرمنتظره: {e}")

if __name__ == '__main__':
    create_admin()