#!/usr/bin/env python3
import subprocess
import os
import time

# مسیر پوشه ربات - تغییر بدید
BOT_PATH = '/home/startoir/beh-gram.ir/ai_bot/bot'

# مسیر Python - از Python App کپی کنید
PYTHON_PATH = '/home/startoir/virtualenv/beh-gram.ir/ai_bot/bot/3.9/bin/python3'

os.chdir(BOT_PATH)
PID_FILE = os.path.join(BOT_PATH, 'bot.pid')
LOG_FILE = os.path.join(BOT_PATH, '../logs/bot.log')  # مسیر کامل

def is_running():
    if not os.path.exists(PID_FILE):
        return False
    try:
        with open(PID_FILE, 'r') as f:
            pid = int(f.read().strip())
        os.kill(pid, 0)
        return True
    except:
        return False

if not is_running():
    # اطمینان از وجود پوشه logs
    log_dir = os.path.dirname(LOG_FILE)
    if not os.path.exists(log_dir):
        os.makedirs(log_dir)
    
    # اطمینان از وجود فایل log
    if not os.path.exists(LOG_FILE):
        open(LOG_FILE, 'a').close()
    
    process = subprocess.Popen(
        [PYTHON_PATH, 'bot.py'],
        stdout=open(LOG_FILE, 'a'),
        stderr=subprocess.STDOUT
    )
    
    with open(PID_FILE, 'w') as f:
        f.write(str(process.pid))