-- ساختار دیتابیس
CREATE TABLE IF NOT EXISTS users (
    id INT PRIMARY KEY AUTO_INCREMENT,
    telegram_id BIGINT UNIQUE NOT NULL,
    username VARCHAR(255),
    first_name VARCHAR(255),
    last_name VARCHAR(255),
    phone_number VARCHAR(20),
    referral_code VARCHAR(20) UNIQUE,
    is_premium BOOLEAN DEFAULT FALSE,
    daily_request_count INT DEFAULT 0,
    total_request_count INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS bot_buttons (
    id INT PRIMARY KEY AUTO_INCREMENT,
    parent_button_id INT,
    button_text VARCHAR(255) NOT NULL,
    button_type ENUM('main_menu', 'sub_menu', 'action') NOT NULL,
    icon_emoji VARCHAR(10),
    is_active BOOLEAN DEFAULT TRUE,
    requires_subscription BOOLEAN DEFAULT FALSE,
    order_index INT DEFAULT 0,
    FOREIGN KEY (parent_button_id) REFERENCES bot_buttons(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS requests (
    id INT PRIMARY KEY AUTO_INCREMENT,
    user_id INT NOT NULL,
    request_type VARCHAR(50) NOT NULL,
    user_input TEXT,
    response_text TEXT,
    status ENUM('pending', 'in_progress', 'completed') DEFAULT 'pending',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS admins (
    id INT PRIMARY KEY AUTO_INCREMENT,
    username VARCHAR(255) UNIQUE NOT NULL,
    email VARCHAR(255),
    password_hash VARCHAR(255) NOT NULL,
    full_name VARCHAR(255),
    role ENUM('super_admin', 'admin', 'moderator') DEFAULT 'moderator',
    can_manage_users BOOLEAN DEFAULT FALSE,
    can_manage_prompts BOOLEAN DEFAULT TRUE,
    can_manage_buttons BOOLEAN DEFAULT TRUE,
    can_view_analytics BOOLEAN DEFAULT TRUE,
    can_manage_admins BOOLEAN DEFAULT FALSE,
    can_manage_settings BOOLEAN DEFAULT FALSE,
    is_active BOOLEAN DEFAULT TRUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS bot_texts (
    id INT PRIMARY KEY AUTO_INCREMENT,
    text_key VARCHAR(100) UNIQUE NOT NULL,
    text_value TEXT NOT NULL,
    description VARCHAR(500)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS system_settings (
    id INT PRIMARY KEY AUTO_INCREMENT,
    setting_key VARCHAR(100) UNIQUE NOT NULL,
    setting_value TEXT,
    setting_type ENUM('string', 'number', 'boolean') NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- داده‌های اولیه
INSERT IGNORE INTO system_settings VALUES
(NULL, 'daily_free_requests', '10', 'number'),
(NULL, 'total_free_requests', '50', 'number');

INSERT IGNORE INTO bot_texts VALUES
(NULL, 'welcome_message', 'سلام {first_name}! به ربات خوش اومدی 🤖', 'پیام خوشامد'),
(NULL, 'share_phone_request', 'شماره تماست رو به اشتراک بذار', 'درخواست شماره');

INSERT IGNORE INTO bot_buttons VALUES
(NULL, NULL, 'ساخت متن', 'main_menu', '🔤', TRUE, FALSE, 1),
(NULL, NULL, 'ساخت عکس', 'main_menu', '🖼', TRUE, FALSE, 2);