<?php
session_start();
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$id = intval($_GET['id'] ?? 0);
$stmt = $pdo->prepare("
    SELECT r.*, u.telegram_id, u.phone 
    FROM requests r 
    JOIN users u ON r.user_id = u.id 
    WHERE r.id = ?
");
$stmt->execute([$id]);
$request = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$request) {
    die("درخواست پیدا نشد.");
}

// اگر وضعیت new بود، به in_progress تغییر بده
if ($request['status'] === 'new') {
    $upd = $pdo->prepare("UPDATE requests SET status='in_progress' WHERE id=?");
    $upd->execute([$id]);
    $request['status'] = 'in_progress';
}
?>
<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>جزئیات درخواست | Video Bot</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <style>
        body { direction: rtl; }
        table th, table td { text-align: right !important; }
        .float-end { float: right !important; }
    </style>
</head>
<body class="bg-light">
<div class="container mt-4">
    <h4 class="mb-3">جزئیات درخواست</h4>
    <a href="dashboard.php" class="btn btn-secondary mb-3 float-end">بازگشت</a>

    <table class="table table-bordered">
        <tr>
            <th>کاربر</th>
            <td><?= htmlspecialchars($request['telegram_id']) ?></td>
        </tr>
        <tr>
            <th>شماره موبایل</th>
            <td><?= htmlspecialchars($request['phone']) ?></td>
        </tr>
        <tr>
            <th>نوع درخواست</th>
            <td>
                <?php
                switch ($request['type']) {
                    case 'text_to_video': echo 'متن به ویدیو'; break;
                    case 'image_to_video': echo 'عکس به ویدیو'; break;
                    case 'text_to_text': echo 'متن به متن'; break;
                    default: echo '<span class="text-danger">نامشخص</span>';
                }
                ?>
            </td>
        </tr>

        <!-- ✅ اصلاح مشکل Enter_LF فقط اینجاست -->
        <tr>
            <th>متن کاربر</th>
            <td>
                <?php
                $text = str_replace('[Enter_LF]', "\n", $request['text_content']);
                echo nl2br(htmlspecialchars($text));
                ?>
            </td>
        </tr>

        <?php if ($request['type'] === 'image_to_video' && !empty($request['image_file'])): ?>
        <tr>
            <th>عکس</th>
            <td>
                <img src="<?= htmlspecialchars($request['image_file']) ?>" class="img-fluid" style="max-width:300px;">
            </td>
        </tr>
        <?php endif; ?>

        <tr>
            <th>وضعیت</th>
            <td><?= htmlspecialchars($request['status']) ?></td>
        </tr>
    </table>

    <?php if($request['type']=='text_to_text'): ?>
    <form method="post" action="send_text.php">
        <input type="hidden" name="request_id" value="<?= $request['id'] ?>">
        <div class="mb-3">
            <label>✍️ متن پاسخ</label>
            <textarea name="answer" class="form-control" rows="6" required></textarea>
        </div>
        <button class="btn btn-success">ارسال پاسخ</button>
    </form>
    <?php endif; ?>

    <?php if ($request['type'] !== 'text_to_text'): ?>
    <hr>
    <form method="post" action="upload_video.php" enctype="multipart/form-data">
        <input type="hidden" name="request_id" value="<?= $request['id'] ?>">

        <div class="mb-3">
            <label>📤 آپلود فایل ویدیو</label>
            <input type="file" name="video_file" class="form-control">
        </div>

        <div class="mb-3">
            <label>🌐 یا لینک مستقیم ویدیو</label>
            <input type="url" name="video_url" class="form-control">
        </div>

        <button type="submit" class="btn btn-success">
            ارسال و تغییر وضعیت به انجام شده
        </button>
    </form>
    <?php endif; ?>

</div>
</body>
</html>
