<?php
session_start();
require_once __DIR__ . '/../includes/config.php';

if (!isset($_SESSION['admin_logged_in'])) exit;

$request_id = intval($_POST['request_id']);
$answer_raw = $_POST['answer'] ?? '';

// 1️⃣ تمیزکاری متن
$answer = trim($answer_raw);

// تبدیل [Enter_LF] به اینتر واقعی
$answer = str_replace('[Enter_LF]', "\n\n", $answer);

// 2️⃣ گرفتن اطلاعات درخواست
$stmt = $pdo->prepare("
    SELECT r.user_message_id, u.telegram_id, u.first_name, u.last_name, u.username
    FROM requests r
    JOIN users u ON r.user_id = u.id
    WHERE r.id=?
");
$stmt->execute([$request_id]);
$info = $stmt->fetch(PDO::FETCH_ASSOC);

if(!$info) exit;

// 3️⃣ ارسال پاسخ به کاربر (با ریپلای)
file_get_contents(
    "https://api.telegram.org/bot".BOT_TOKEN."/sendMessage?".
    http_build_query([
        'chat_id' => $info['telegram_id'],
        'text'    => $answer,
        'reply_to_message_id' => $info['user_message_id']
    ])
);

// 4️⃣ ساخت نام نمایشی کاربر
$full_name = trim($info['first_name'].' '.$info['last_name']);
$user_line = "👤 {$full_name}";
if(!empty($info['username'])){
    $user_line .= " (@{$info['username']})";
}

// 5️⃣ ارسال به کانال (همه در یک پیام)
$channel_text =
"📝 پاسخ متن به متن
📌 درخواست #{$request_id}
{$user_line}

✍️ متن پاسخ:
{$answer}";

file_get_contents(
    "https://api.telegram.org/bot".BOT_TOKEN."/sendMessage?".
    http_build_query([
        'chat_id' => PRIVATE_CHANNEL_ID,
        'text'    => $channel_text
    ])
);

// 6️⃣ ذخیره پاسخ در دیتابیس (خیلی مهم)
$pdo->prepare("
    UPDATE requests
    SET 
        answer_text = ?,
        status = 'done',
        completed_at = NOW()
    WHERE id = ?
")->execute([$answer, $request_id]);

header("Location: request_view.php?id=".$request_id);
exit;
