<?php
function gregorian_to_jalali($gy, $gm, $gd) {
    $g_d_m = array(0,31,59,90,120,151,181,212,243,273,304,334);
    if($gy > 1600){
        $jy = 979;
        $gy -= 1600;
    } else {
        $jy = 0;
        $gy -= 621;
    }
    $gy2 = ($gm > 2)?($gy + 1):$gy;
    $days = 365*$gy + intval(($gy2+3)/4) - intval(($gy2+99)/100) + intval(($gy2+399)/400) - 80 + $gd + $g_d_m[$gm-1];
    $jy += 33*intval($days/12053);
    $days %= 12053;
    $jy += 4*intval($days/1461);
    $days %= 1461;
    if($days > 365){
        $jy += intval(($days-1)/365);
        $days = ($days-1)%365;
    }
    if($days < 186){
        $jm = 1 + intval($days/31);
        $jd = 1 + ($days % 31);
    } else {
        $jm = 7 + intval(($days-186)/30);
        $jd = 1 + (($days-186) % 30);
    }
    return array($jy, $jm, $jd);
}

function jdate($date) {
    date_default_timezone_set('Asia/Tehran'); 
    $timestamp = strtotime($date);
    $g = getdate($timestamp);
    list($jy, $jm, $jd) = gregorian_to_jalali($g['year'], $g['mon'], $g['mday']);
    $months = ['فروردین','اردیبهشت','خرداد','تیر','مرداد','شهریور','مهر','آبان','آذر','دی','بهمن','اسفند'];
    return $jd . ' ' . $months[$jm-1] . ' ' . $jy . ' - ' . $g['hours'] . ':' . sprintf('%02d', $g['minutes']);
}
?>
