<?php
session_start();
require_once __DIR__ . '/../includes/config.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// ذخیره تنظیمات
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    foreach ($_POST['settings'] as $key => $value) {
        $stmt = $pdo->prepare("
            UPDATE bot_settings SET setting_value=? WHERE setting_key=?
        ");
        $stmt->execute([$value, $key]);
    }
    $success = true;
}

// خواندن تنظیمات
$stmt = $pdo->query("SELECT * FROM bot_settings");
$settings = $stmt->fetchAll(PDO::FETCH_ASSOC);

// کمکی برای ترجمه
function status_fa($v){
    switch($v){
        case 'enabled': return 'فعال';
        case 'disabled': return 'غیرفعال کامل';
        case 'maintenance': return 'در دست توسعه';
        default: return $v;
    }
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>تنظیمات ربات</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <style>
        body { direction: rtl; background:#f8f9fa; }
        .container { max-width: 700px; }
    </style>
</head>
<body>

<div class="container mt-5">
    <h4 class="mb-4 text-center">⚙️ تنظیمات قابلیت‌های ربات</h4>

    <?php if (!empty($success)): ?>
        <div class="alert alert-success text-center">
            تنظیمات با موفقیت ذخیره شد
        </div>
    <?php endif; ?>

    <form method="post">

        <?php foreach ($settings as $s): ?>
            <div class="mb-4 p-3 border rounded bg-white">
                <strong>
                    <?php
                    switch($s['setting_key']){
                        case 'text_to_text': echo '📝 متن به متن'; break;
                        case 'text_to_video': echo '🎬 متن به ویدیو'; break;
                        case 'image_to_video': echo '🖼️ عکس به ویدیو'; break;
                        default: echo $s['setting_key'];
                    }
                    ?>
                </strong>

                <select name="settings[<?= $s['setting_key'] ?>]" class="form-select mt-2">
                    <option value="enabled" <?= $s['setting_value']=='enabled'?'selected':'' ?>>فعال</option>
                    <option value="maintenance" <?= $s['setting_value']=='maintenance'?'selected':'' ?>>در دست توسعه</option>
                    <option value="disabled" <?= $s['setting_value']=='disabled'?'selected':'' ?>>غیرفعال کامل</option>
                </select>

                <div class="text-muted mt-2 small">
                    وضعیت فعلی: <strong><?= status_fa($s['setting_value']) ?></strong>
                </div>
            </div>
        <?php endforeach; ?>

        <button class="btn btn-primary w-100">💾 ذخیره تنظیمات</button>
    </form>

    <div class="text-center mt-4">
        <a href="dashboard.php" class="btn btn-secondary btn-sm">بازگشت به داشبورد</a>
    </div>
</div>

</body>
</html>
