<?php
require_once '../includes/auth.php';
require_once '../../includes/config.php';

$id = intval($_GET['id']);

$prompt = $pdo->prepare("SELECT * FROM mega_prompts WHERE id=?");
$prompt->execute([$id]);
$p = $prompt->fetch();

if (!$p) exit('Not found');

if ($_POST) {
    $pdo->prepare("
        UPDATE mega_prompts SET
        title=?, slug=?, prompt_text=?, status=?
        WHERE id=?
    ")->execute([
        $_POST['title'],
        $_POST['slug'],
        $_POST['prompt_text'],
        $_POST['status'],
        $id
    ]);
    header("Location: index.php");
    exit;
}
?>

<h2>✏️ ویرایش</h2>

<form method="post">
<input name="title" value="<?= htmlspecialchars($p['title']) ?>"><br><br>
<input name="slug" value="<?= $p['slug'] ?>"><br><br>
<textarea name="prompt_text"><?= htmlspecialchars($p['prompt_text']) ?></textarea><br><br>

<select name="status">
  <option value="active" <?= $p['status']=='active'?'selected':'' ?>>فعال</option>
  <option value="inactive" <?= $p['status']=='inactive'?'selected':'' ?>>غیرفعال</option>
</select><br><br>

<button>ذخیره</button>
</form>
