<?php
require_once '../includes/auth.php';
require_once '../../includes/config.php';

$prompt_id = intval($_GET['id']);

$questions = $pdo->prepare("
    SELECT * FROM mega_prompt_questions
    WHERE prompt_id=?
    ORDER BY step ASC
");
$questions->execute([$prompt_id]);
?>

<h2>❓ سوالات پرامپت</h2>
<a href="question_add.php?prompt_id=<?= $prompt_id ?>">➕ افزودن سوال</a>

<table border="1">
<tr>
  <th>مرحله</th>
  <th>سوال</th>
  <th>عملیات</th>
</tr>

<?php foreach($questions as $q): ?>
<tr>
  <td><?= $q['step'] ?></td>
  <td><?= htmlspecialchars($q['question_text']) ?></td>
  <td>
    <a href="question_edit.php?id=<?= $q['id'] ?>">✏️</a>
    <a href="question_delete.php?id=<?= $q['id'] ?>">🗑</a>
  </td>
</tr>
<?php endforeach; ?>
</table>
