<?php
// handlers/mega_prompt.php

function detectMegaPrompt($text, $pdo) {

    if (strpos($text, '/start ') !== 0) {
        return null;
    }

    $parts = explode(' ', $text);
    $slug  = $parts[1] ?? null;

    if (!$slug) {
        return null;
    }

    $stmt = $pdo->prepare("
        SELECT * FROM mega_prompts
        WHERE slug = ? AND status = 'active'
        LIMIT 1
    ");
    $stmt->execute([$slug]);

    return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
}
