<?php
session_start();
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';

// امنیت: بررسی ورود ادمین
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// تابع کمکی برای نمایش وضعیت فارسی
function status_fa($status){
    switch($status){
        case 'new': return 'جدید';
        case 'in_progress': return 'در حال انجام';
        case 'done': return 'انجام شده';
        default: return htmlspecialchars($status);
    }
}

// 10 آخرین کاربران
$usersStmt = $pdo->query("
    SELECT u.*, COUNT(r.id) AS requests_count
    FROM users u
    LEFT JOIN requests r ON r.user_id = u.id
    GROUP BY u.id
    ORDER BY u.created_at DESC
    LIMIT 10
");
$users = $usersStmt->fetchAll(PDO::FETCH_ASSOC);

// 10 آخرین درخواست‌ها
$requestsStmt = $pdo->query("
    SELECT r.*, u.telegram_id, u.phone
    FROM requests r
    JOIN users u ON r.user_id = u.id
    ORDER BY r.created_at DESC
    LIMIT 10
");
$requests = $requestsStmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>داشبورد ادمین | Video Bot</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <style>
        body { direction: rtl; text-align: right; }
        table th, table td { text-align: center; vertical-align: middle; }
    </style>
</head>
<body class="bg-light">
<div class="container mt-5">
    <h3 class="text-center mb-4">پنل مدیریت ربات</h3>

    <div class="text-center mb-4">
        <a href="logout.php" class="btn btn-danger">خروج</a>
    </div>

    <!-- آخرین کاربران -->
    <h5>10 کاربر آخر</h5>
    <table class="table table-bordered table-striped text-center">
        <thead class="table-light">
            <tr>
                <th>#</th>
                <th>تاریخ ثبت</th>
                <th>Telegram ID</th>
                <th>نام</th>
                <th>نام خانوادگی</th>
                <th>یوزرنیم</th>
                <th>شماره موبایل</th>
                <th>تعداد درخواست‌ها</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach($users as $i => $u): ?>
            <tr>
                <td><?= $i+1 ?></td>
                <td><?= jdate($u['created_at']) ?></td>
                <td><?= htmlspecialchars($u['telegram_id']) ?></td>
                <td><?= htmlspecialchars($u['first_name'] ?: '-') ?></td>
                <td><?= htmlspecialchars($u['last_name'] ?: '-') ?></td>
                <td><?= htmlspecialchars($u['username'] ?: '-') ?></td>
                <td><?= htmlspecialchars($u['phone']) ?></td>
                <td><?= $u['requests_count'] ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    <div class="text-end mb-4">
        <a href="users_list.php" class="btn btn-primary btn-sm">مشاهده همه کاربران</a>
    </div>

    <!-- آخرین درخواست‌ها -->
    <h5>10 درخواست آخر</h5>
    <table class="table table-bordered table-striped text-center">
        <thead class="table-light">
            <tr>
                <th>#</th>
                <th>تاریخ ارسال</th>
                <th>کاربر</th>
                <th>نوع درخواست</th>
                <th>وضعیت</th>
                <th>عملیات</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach($requests as $i => $r): ?>
            <tr>
                <td><?= $i+1 ?></td>
                <td><?= jdate($r['created_at']) ?></td>
                <td><?= htmlspecialchars($r['telegram_id']) ?></td>
                <td><?= $r['type'] == 'text_to_video' ? 'متن به ویدیو' : 'عکس به ویدیو' ?></td>
                <td><?= status_fa($r['status']) ?></td>
                <td>

    <?php 
        // تعیین رنگ دکمه بر اساس وضعیت درخواست
        switch($r['status']){
            case 'new':
                $btn_class = 'btn btn-danger'; // جدید → قرمز
                break;
            case 'in_progress':
                $btn_class = 'btn btn-primary'; // در حال انجام → آبی
                break;
            case 'done':
                $btn_class = 'btn btn-success'; // انجام شده → سبز
                break;
            default:
                $btn_class = 'btn btn-secondary'; // سایر وضعیت‌ها → خاکستری
        }
    ?>
    <a href="request_view.php?id=<?= $r['id'] ?>" class="<?= $btn_class ?> btn-sm">مشاهده</a>


                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    <div class="text-end mb-4">
        <a href="requests_list.php" class="btn btn-primary btn-sm">مشاهده همه درخواست‌ها</a>
    </div>

</div>
</body>
</html>
