<?php
session_start();
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// تابع کمکی برای نمایش فارسی وضعیت
function status_fa($status){
    switch($status){
        case 'new': return 'جدید';
        case 'in_progress': return 'در حال انجام';
        case 'done': return 'انجام شده';
        default: return htmlspecialchars($status);
    }
}

// فقط درخواست‌های جدید
$requestsStmt = $pdo->query("
    SELECT r.*, u.telegram_id, u.phone
    FROM requests r
    JOIN users u ON r.user_id = u.id
    WHERE r.status = 'new'
    ORDER BY r.created_at DESC
");
$requests = $requestsStmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>درخواست‌های جدید | Video Bot</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <style>
        body { direction: rtl; text-align: right; }
        table th, table td { text-align: center; vertical-align: middle; }
    </style>
</head>
<body class="bg-light">
<div class="container mt-4">
    <h3 class="text-center mb-3">📥 درخواست‌های جدید</h3>

    <div class="text-center mb-3">
        <a href="dashboard.php" class="btn btn-secondary">بازگشت به داشبورد</a>
        <a href="requests_list.php" class="btn btn-outline-primary">مشاهده همه درخواست‌ها</a>
    </div>

    <?php if (empty($requests)): ?>
        <div class="alert alert-success text-center">هیچ درخواست جدیدی وجود ندارد 🎉</div>
    <?php else: ?>
        <table class="table table-bordered table-striped text-center align-middle">
            <thead class="table-light">
                <tr>
                    <th>#</th>
                    <th>تاریخ ارسال</th>
                    <th>کاربر</th>
                    <th>نوع درخواست</th>
                    <th>وضعیت</th>
                    <th>عملیات</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach($requests as $i => $r): ?>
                <tr>
                    <td><?= $i + 1 ?></td>
                    <td><?= jdate($r['created_at']) ?></td>
                    <td><?= htmlspecialchars($r['telegram_id']) ?></td>
                    <td><?= $r['type'] == 'text_to_video' ? 'متن به ویدیو' : 'عکس به ویدیو' ?></td>
                    <td><?= status_fa($r['status']) ?></td>
                    <td>
                        <a href="request_view.php?id=<?= $r['id'] ?>" class="btn btn-danger btn-sm">مشاهده</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>
</body>
</html>
