<?php
session_start();
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$id = intval($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT r.*, u.telegram_id, u.phone FROM requests r JOIN users u ON r.user_id = u.id WHERE r.id = ?");
$stmt->execute([$id]);
$request = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$request) {
    die("درخواست پیدا نشد.");
}

// اگر وضعیت new بود، به in_progress تغییر بده
if ($request['status'] == 'new') {
    $upd = $pdo->prepare("UPDATE requests SET status='in_progress' WHERE id=?");
    $upd->execute([$id]);
    $request['status'] = 'in_progress';
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>جزئیات درخواست | Video Bot</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <style>
        body {
            direction: rtl;
        }
        table th, table td {
            text-align: right !important;
        }
        .text-end {
            text-align: right !important;
        }
        .float-end {
            float: right !important;
        }
    </style>
</head>
<body class="bg-light">
<div class="container mt-4">
    <h4 class="mb-3">جزئیات درخواست</h4>
    <a href="dashboard.php" class="btn btn-secondary mb-3 float-end">بازگشت</a>

    <table class="table table-bordered text-end">
        <tr>
            <th>کاربر</th>
            <td><?= htmlspecialchars($request['telegram_id']) ?></td>
        </tr>
        <tr>
            <th>شماره موبایل</th>
            <td><?= htmlspecialchars($request['phone']) ?></td>
        </tr>
        <tr>
            <th>نوع درخواست</th>
            <td><?= $request['type']=='text_to_video' ? 'متن به ویدیو' : 'عکس به ویدیو' ?></td>
        </tr>
        <tr>
            <th>متن</th>
            <td><?= nl2br(htmlspecialchars($request['text_content'])) ?></td>
        </tr>
        <?php if (!empty($request['image_file'])): ?>
        <tr>
            <th>عکس</th>
            <td>
                <?php 
                $img_file = $_SERVER['DOCUMENT_ROOT'] . $request['image_file']; // مسیر واقعی روی سرور
                if(file_exists($img_file)){
                    echo "<img src='".$request['image_file']."' style='max-width:300px;' class='img-fluid'>";
                } else {
                    echo "عکس موجود نیست";
                }
                ?>
            </td>
        </tr>
        <?php endif; ?>
        <tr>
            <th>وضعیت</th>
            <td>
                <?php
                switch($request['status']){
                    case 'new':
                        echo 'جدید';
                        break;
                    case 'in_progress':
                        echo 'در حال انجام';
                        break;
                    case 'done':
                        echo 'انجام شده';
                        break;
                    default:
                        echo htmlspecialchars($request['status']);
                }
                ?>
            </td>
        </tr>

        <?php if (!empty($request['video_link'])): ?>
        <tr>
            <th>لینک ویدیو</th>
            <td>
                <a href="<?= htmlspecialchars($request['video_link']) ?>" target="_blank">مشاهده ویدیو</a>
            </td>
        </tr>
        <?php endif; ?>

    </table>

<form method="post" action="upload_video.php" enctype="multipart/form-data" class="mt-4">
    <input type="hidden" name="request_id" value="<?= $request['id'] ?>">

    <div class="mb-3">
        <label>📤 آپلود فایل ویدیو از کامپیوتر</label>
        <input type="file" name="video_file" class="form-control">
    </div>

    <div class="mb-3">
        <label>🌐 یا لینک مستقیم ویدیو را وارد کنید</label>
        <input type="url" name="video_url" class="form-control" placeholder="مثلاً https://example.com/video.mp4">
    </div>

    <button type="submit" class="btn btn-success">ارسال و تغییر وضعیت به انجام شده</button>
</form>

</div>
</body>
</html>
