<?php
session_start();
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: dashboard.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>ارسال پیام | Video Bot</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <style>
        body {
            direction: rtl;
        }
        .text-end {
            text-align: right !important;
        }
        .form-label {
            float: right;
        }
    </style>
</head>
<body class="bg-light">
<div class="container mt-4">
    <h3 class="mb-3">ارسال پیام به کاربران</h3>
    <a href="dashboard.php" class="btn btn-secondary mb-3">بازگشت به داشبورد</a>

    <form method="post" action="send_message_action.php" enctype="multipart/form-data" class="text-end">
        <!-- انتخاب گیرنده پیام -->
        <div class="mb-3">
            <label class="form-label">گیرنده پیام:</label>
            <select name="user_id_option" class="form-select" id="userOptionSelect">
                <option value="all">همه کاربران</option>
                <option value="specific">یک کاربر خاص (Telegram ID)</option>
            </select>
        </div>

        <!-- وارد کردن Telegram ID کاربر خاص -->
        <div class="mb-3" id="specificUserDiv" style="display:none;">
            <label class="form-label">Telegram ID کاربر:</label>
            <input type="number" name="specific_user_telegram_id" class="form-control" placeholder="مثال: 123456789">
            <small class="text-muted">Telegram ID عددی کاربر را وارد کنید.</small>
        </div>

        <!-- متن پیام -->
        <div class="mb-3">
            <label class="form-label">متن پیام</label>
            <textarea name="message_text" class="form-control text-end" rows="3" required></textarea>
        </div>

        <!-- آپلود فایل رسانه -->
        <div class="mb-3">
            <label class="form-label">آپلود عکس یا ویدیو (اختیاری)</label>
            <input type="file" name="media_file" class="form-control">
        </div>

        <button type="submit" class="btn btn-success float-end">ارسال پیام</button>
    </form>
</div>

<script>
    // نمایش یا مخفی کردن فیلد Telegram ID بر اساس انتخاب
    const userOptionSelect = document.getElementById('userOptionSelect');
    const specificUserDiv = document.getElementById('specificUserDiv');

    userOptionSelect.addEventListener('change', function() {
        specificUserDiv.style.display = this.value === 'specific' ? 'block' : 'none';
    });
</script>
</body>
</html>
