<?php
session_start();
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: dashboard.php");
    exit;
}

$user_option = $_POST['user_id_option'] ?? 'all';
$specific_user_telegram_id = trim($_POST['specific_user_telegram_id'] ?? '');
$message_text = trim($_POST['message_text'] ?? '');
$media_file = $_FILES['media_file'] ?? null;

if (empty($message_text) && (!$media_file || !$media_file['tmp_name'])) {
    die("پیام یا فایل حداقل یکی باید ارسال شود.");
}

// ۱️⃣ تعیین لیست کاربران هدف
$target_users = [];

if ($user_option === 'all') {
    $stmt = $pdo->query("SELECT telegram_id FROM users");
    $target_users = $stmt->fetchAll(PDO::FETCH_COLUMN);
} elseif ($user_option === 'specific' && $specific_user_telegram_id) {
    $stmt = $pdo->prepare("SELECT telegram_id FROM users WHERE telegram_id=?");
    $stmt->execute([$specific_user_telegram_id]);
    $telegram_id = $stmt->fetchColumn();
    if ($telegram_id) {
        $target_users[] = $telegram_id;
    } else {
        die("کاربر مورد نظر پیدا نشد.");
    }
} else {
    die("انتخاب نامعتبر.");
}

// ۲️⃣ آپلود فایل (در صورت وجود)
$media_path = null;
$media_type = null;
if ($media_file && $media_file['tmp_name']) {
    $uploadDir = __DIR__ . '/../uploads/';
    $filename = time() . '_' . basename($media_file['name']);
    $targetFile = $uploadDir . $filename;

    if (!move_uploaded_file($media_file['tmp_name'], $targetFile)) {
        die("خطا در آپلود فایل.");
    }
    $media_path = $targetFile;

    $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
    if (in_array($ext, ['mp4','mov','avi','mkv'])) $media_type = 'video';
    else $media_type = 'photo';
}

// ۳️⃣ ارسال پیام به همه کاربران هدف
foreach ($target_users as $chat_id) {
    if ($media_path) {
        // ارسال عکس یا ویدیو
        $curl = curl_init();
        $post_fields = ['chat_id' => $chat_id, 'caption' => $message_text];

        if ($media_type === 'video') $post_fields['video'] = new CURLFile($media_path);
        else $post_fields['photo'] = new CURLFile($media_path);

        curl_setopt_array($curl, [
            CURLOPT_URL => "https://api.telegram.org/bot".BOT_TOKEN."/send".($media_type === 'video' ? 'Video' : 'Photo'),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post_fields
        ]);

        curl_exec($curl);
        curl_close($curl);
    } else {
        // فقط متن
        file_get_contents("https://api.telegram.org/bot".BOT_TOKEN."/sendMessage?chat_id=$chat_id&text=".urlencode($message_text));
    }
}

// ۴️⃣ حذف فایل از هاست بعد از ارسال
if ($media_path) unlink($media_path);

// ۵️⃣ ریدایرکت با پیام موفقیت
header("Location: send_message.php?success=1");
exit;
