<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';

// بررسی ورود ادمین
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$request_id = intval($_POST['request_id']);
$video_url = trim($_POST['video_url'] ?? '');

// مسیر آپلود در سرور
$uploadDir = __DIR__ . '/../uploads/videos/';
if (!is_dir($uploadDir)) mkdir($uploadDir, 0755, true);

$filename = '';
$targetFile = '';
$webPath = '';

if (!empty($_FILES['video_file']['tmp_name'])) {
    // ✅ حالت آپلود فایل از سیستم
    $filename = time() . '_' . basename($_FILES['video_file']['name']);
    $targetFile = $uploadDir . $filename;

    if (!move_uploaded_file($_FILES['video_file']['tmp_name'], $targetFile)) {
        die("خطا در آپلود فایل روی سرور.");
    }

    $webPath = '/video-bot/uploads/videos/' . $filename;

} elseif (!empty($video_url)) {
    // ✅ حالت لینک مستقیم
    $filename = time() . '_' . basename(parse_url($video_url, PHP_URL_PATH));
    $targetFile = $uploadDir . $filename;

    $videoData = @file_get_contents($video_url);
    if ($videoData === false) {
        die("دانلود ویدیو از لینک با خطا مواجه شد. لطفاً لینک را بررسی کنید.");
    }

    file_put_contents($targetFile, $videoData);
    $webPath = '/video-bot/uploads/videos/' . $filename;

} else {
    die("لطفاً فایل ویدیو انتخاب کنید یا لینک مستقیم وارد نمایید.");
}

// بروزرسانی دیتابیس
$stmt = $pdo->prepare("UPDATE requests 
    SET video_file=?, video_url=?, status='done', completed_at=NOW() 
    WHERE id=?");
$stmt->execute([$webPath, $video_url, $request_id]);

// گرفتن اطلاعات کاربر درخواست‌کننده
$stmt = $pdo->prepare("SELECT telegram_id, id FROM users WHERE id=(SELECT user_id FROM requests WHERE id=?)");
$stmt->execute([$request_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) die("کاربر درخواست‌کننده پیدا نشد.");
$chat_id_user = $user['telegram_id'];

// ============================
// ۱️⃣ ارسال ویدیو به کانال
// ============================

// دریافت پرامپت و اطلاعات کاربر برای کپشن
$stmtPrompt = $pdo->prepare("
    SELECT r.text_content, u.username, u.telegram_id
    FROM requests r
    JOIN users u ON r.user_id = u.id
    WHERE r.id = ?
");
$stmtPrompt->execute([$request_id]);
$data = $stmtPrompt->fetch(PDO::FETCH_ASSOC);

$promptText = $data && !empty($data['text_content']) ? trim($data['text_content']) : '— بدون متن —';
$username = $data && !empty($data['username']) ? '@' . ltrim($data['username'], '@') : $data['telegram_id'];

$channel_id = PRIVATE_CHANNEL_ID;

$curlFile = new CURLFile(realpath($targetFile));

// کپشن نهایی برای کانال
$captionChannel = "🎬 ویدیوی آماده‌شده برای درخواست #{$request_id}\n"
    . "👤 کاربر: {$username}\n\n"
    . "📝 پرامپت:\n{$promptText}";

$postDataChannel = [
    'chat_id' => $channel_id,
    'video' => $curlFile,
    'caption' => $captionChannel
];

$ch = curl_init("https://api.telegram.org/bot" . BOT_TOKEN . "/sendVideo");
curl_setopt_array($ch, [
    CURLOPT_POST => 1,
    CURLOPT_POSTFIELDS => $postDataChannel,
    CURLOPT_RETURNTRANSFER => true
]);
$response = curl_exec($ch);
if ($response === false) {
    die("خطا در ارسال ویدیو به کانال: " . curl_error($ch));
}
curl_close($ch);



// ============================
// ۲️⃣ ارسال ویدیو به کاربر
// ============================
$curlFileUser = new CURLFile(realpath($targetFile));
$postDataUser = [
    'chat_id' => $chat_id_user,
    'video' => $curlFileUser,
    'caption' => "🎬 ویدیوی شما آماده شد!\n\nپرامپت: " . getPromptText($pdo, $request_id)
];

$ch2 = curl_init("https://api.telegram.org/bot".BOT_TOKEN."/sendVideo");
curl_setopt_array($ch2, [
    CURLOPT_POST => 1,
    CURLOPT_POSTFIELDS => $postDataUser,
    CURLOPT_RETURNTRANSFER => true
]);
curl_exec($ch2);
curl_close($ch2);

// اطلاع ادمین
if (defined('ADMIN_CHAT_ID')) {
    $msg = "✅ درخواست #{$request_id} انجام شد.\nکاربر: {$chat_id_user}";
    file_get_contents("https://api.telegram.org/bot".BOT_TOKEN."/sendMessage?chat_id=".ADMIN_CHAT_ID."&text=".urlencode($msg));
}

// ✅ فایل در سرور باقی می‌مونه
header("Location: request_view.php?id=" . $request_id . "&success=1");
exit;

// تابع گرفتن پرامپت
function getPromptText($pdo, $req_id) {
    $s = $pdo->prepare("SELECT text_content FROM requests WHERE id=?");
    $s->execute([$req_id]);
    $r = $s->fetch(PDO::FETCH_ASSOC);
    return $r ? $r['text_content'] : '';
}
?>
