<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';

$content = file_get_contents("php://input");
$update = json_decode($content, true);

if (!$update) exit;

$chat_id   = $update['message']['chat']['id'] ?? null;
$text      = $update['message']['text'] ?? '';
$contact   = $update['message']['contact']['phone_number'] ?? '';
$first_name = $update['message']['from']['first_name'] ?? '';
$last_name  = $update['message']['from']['last_name'] ?? '';
$username   = $update['message']['from']['username'] ?? '';


// ======================================================================
// دریافت شماره موبایل و ثبت کاربر
// ======================================================================
if (isset($update['message']['contact'])) {

    $stmt = $pdo->prepare("
        INSERT INTO users (telegram_id, first_name, last_name, username, phone, created_at)
        VALUES (?, ?, ?, ?, ?, NOW())
        ON DUPLICATE KEY UPDATE 
            first_name=?, last_name=?, username=?, phone=?
    ");
    $stmt->execute([
        $chat_id, $first_name, $last_name, $username, $contact,
        $first_name, $last_name, $username, $contact
    ]);

    $keyboard = [
        'keyboard' => [
            [
                ['text'=>'ساخت ویدیو با متن'],
                ['text'=>'ساخت ویدیو از روی عکس'],
                ['text'=>'متن به متن']
            ]
        ],
        'resize_keyboard'=>true
    ];

    sendMessage($chat_id, "گزینه مورد نظر را انتخاب کنید:", $keyboard);
    exit;
}


// ======================================================================
// /start
// ======================================================================
if ($text == '/start') {

    $keyboard = [
        'keyboard'=>[
            [
                ['text'=>'ارسال شماره', 'request_contact'=>true]
            ]
        ],
        'resize_keyboard'=>true
    ];

    sendMessage($chat_id, "سلام! لطفا شماره خود را ارسال کنید:", $keyboard);
    exit;
}



// ⚡ دریافت user_id
function getUserId($chat_id, $pdo){
    $stmt = $pdo->prepare("SELECT id FROM users WHERE telegram_id=? LIMIT 1");
    $stmt->execute([$chat_id]);
    return $stmt->fetch(PDO::FETCH_ASSOC)['id'] ?? null;
}



// ======================================================================
// درخواست ساخت ویدیو از متن
// ======================================================================
if ($text == 'ساخت ویدیو با متن') {

    $user_id = getUserId($chat_id, $pdo);
    if (!$user_id) exit;

    // ایجاد درخواست جدید
    $stmt = $pdo->prepare("
        INSERT INTO requests (user_id, type, status, step, created_at)
        VALUES (?, 'text_to_video', 'new', 'waiting_text', NOW())
    ");
    $stmt->execute([$user_id]);

    sendMessage($chat_id, "لطفا متن ویدیو را ارسال کنید:");
    exit;
}



// ======================================================================
// درخواست ساخت ویدیو از روی عکس
// ======================================================================
if ($text == 'ساخت ویدیو از روی عکس') {

    $user_id = getUserId($chat_id, $pdo);
    if (!$user_id) exit;

    // ثبت درخواست جدید
    $stmt = $pdo->prepare("
        INSERT INTO requests (user_id, type, status, step, created_at)
        VALUES (?, 'image_to_video', 'new', 'waiting_image', NOW())
    ");
    $stmt->execute([$user_id]);

    sendMessage($chat_id, "لطفا ابتدا عکس خود را ارسال کنید:");
    exit;
}



// ======================================================================
// متن به متن
// ======================================================================
if ($text == 'متن به متن') {

    $user_id = getUserId($chat_id, $pdo);
    if (!$user_id) exit;

    // ثبت درخواست جدید text_to_text
    $stmt = $pdo->prepare("
        INSERT INTO requests (user_id, type, status, step, created_at)
        VALUES (?, 'text_to_text', 'new', 'waiting_text', NOW())
    ");
    $stmt->execute([$user_id]);

    sendMessage($chat_id, "لطفا متن خود را ارسال کنید:");
    exit;
}



// ======================================================================
// دریافت عکس
// ======================================================================
if (isset($update['message']['photo'])) {

    $user_id = getUserId($chat_id, $pdo);
    if (!$user_id) exit;

    $caption = $update['message']['caption'] ?? '';
    $photos = $update['message']['photo'];
    $photo_id = end($photos)['file_id'];

    // گرفتن آخرین درخواست image_to_video که در انتظار عکس است
    $stmt = $pdo->prepare("
        SELECT * FROM requests 
        WHERE user_id=? AND type='image_to_video' AND step='waiting_image'
        ORDER BY id DESC LIMIT 1
    ");
    $stmt->execute([$user_id]);
    $req = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$req) {
        sendMessage($chat_id, "شما در حال حاضر درخواستی برای تبدیل عکس به ویدیو ندارید.");
        exit;
    }


    // دانلود عکس
    $res = json_decode(file_get_contents(
        "https://api.telegram.org/bot".BOT_TOKEN."/getFile?file_id=".$photo_id
    ), true);

    $file_path = $res['result']['file_path'] ?? null;
    if (!$file_path) exit;

    $uploadDir = __DIR__ . '/../uploads/images/';
    if (!is_dir($uploadDir)) mkdir($uploadDir, 0755, true);

    $filename = time().'_'.basename($file_path);
    $save_path = $uploadDir.$filename;

    file_put_contents(
        $save_path,
        file_get_contents("https://api.telegram.org/file/bot".BOT_TOKEN."/".$file_path)
    );

    $web_path = '/video-bot/uploads/images/'.$filename;


    // اگر کپشن دارد → درخواست کامل است
    if ($caption) {
        $stmt = $pdo->prepare("
            UPDATE requests 
            SET image_file=?, text_content=?, step='complete'
            WHERE id=?
        ");
        $stmt->execute([$web_path, $caption, $req['id']]);

        sendMessage($chat_id, "درخواست شما ثبت شد. لطفا منتظر بمانید.");
        exit;
    }

    // اگر کپشن ندارد → فقط عکس ثبت می‌شود
    $stmt = $pdo->prepare("
        UPDATE requests 
        SET image_file=?, step='waiting_text'
        WHERE id=?
    ");
    $stmt->execute([$web_path, $req['id']]);

    sendMessage($chat_id, "عکس دریافت شد. لطفا متن خود را ارسال کنید.");
    exit;
}



// ======================================================================
// دریافت متن (متن آزاد)
// ======================================================================
// ======================================================================
// دریافت متن
// ======================================================================
if ($text) {

    $user_id = getUserId($chat_id, $pdo);
    if (!$user_id) exit;


    // 1️⃣ اگر کاربر در حالت image_to_video منتظر عکس بوده و اشتباهی متن فرستاده:
    $stmt = $pdo->prepare("
        SELECT * FROM requests
        WHERE user_id=? AND type='image_to_video' AND step='waiting_image'
        ORDER BY id DESC LIMIT 1
    ");
    $stmt->execute([$user_id]);
    $imgWaitingImage = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($imgWaitingImage) {

        // متن ذخیره می‌شود اما درخواست هنوز کامل نیست
        $stmt = $pdo->prepare("
            UPDATE requests
            SET text_content=?, step='waiting_image'
            WHERE id=?
        ");
        $stmt->execute([$text, $imgWaitingImage['id']]);

        sendMessage($chat_id, "متن دریافت شد. لطفا عکس خود را ارسال کنید:");
        exit;
    }


    // 2️⃣ اگر کاربر قبلاً عکس ارسال کرده و اکنون منتظر متن هستیم
    $stmt = $pdo->prepare("
        SELECT * FROM requests
        WHERE user_id=? AND type='image_to_video' AND step='waiting_text'
        ORDER BY id DESC LIMIT 1
    ");
    $stmt->execute([$user_id]);
    $imgWaitingText = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($imgWaitingText) {

        // درخواست کامل می‌شود
        $stmt = $pdo->prepare("
            UPDATE requests
            SET text_content=?, step='complete'
            WHERE id=?
        ");
        $stmt->execute([$text, $imgWaitingText['id']]);

        sendMessage($chat_id, "درخواست شما ثبت شد. لطفا منتظر بمانید.");
        exit;
    }


    // 3️⃣ متن به متن — کاربر متن را فرستاده
    $stmt = $pdo->prepare("
        SELECT * FROM requests
        WHERE user_id=? AND type='text_to_text' AND status='new'
        ORDER BY id DESC LIMIT 1
    ");
    $stmt->execute([$user_id]);
    $txtReq = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($txtReq) {

        // درخواست تکمیل شود
        $stmt = $pdo->prepare("
            UPDATE requests
            SET text_content=?, step='complete'
            WHERE id=?
        ");
        $stmt->execute([$text, $txtReq['id']]);

        sendMessage($chat_id, "متن شما ثبت شد و به زودی ارسال می‌شود.");
        exit;
    }


    // 4️⃣ متن به ویدیو
    $stmt = $pdo->prepare("
        SELECT * FROM requests
        WHERE user_id=? AND type='text_to_video' AND status='new'
        ORDER BY id DESC LIMIT 1
    ");
    $stmt->execute([$user_id]);
    $txtVid = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($txtVid) {

        $stmt = $pdo->prepare("
            UPDATE requests
            SET text_content=?, step='complete'
            WHERE id=?
        ");
        $stmt->execute([$text, $txtVid['id']]);

        sendMessage($chat_id, "درخواست شما ثبت شد. لطفا چند لحظه منتظر باشید.");
        exit;
    }


    // اگر هیچ درخواست فعالی نبود
    sendMessage($chat_id, "لطفا یکی از گزینه‌های منو را انتخاب کنید.");
    exit;
}




// ======================================================================
// تابع ارسال پیام
// ======================================================================
function sendMessage($chat_id, $text, $keyboard = null) {
    $url = "https://api.telegram.org/bot".BOT_TOKEN."/sendMessage?chat_id=$chat_id&text=".urlencode($text);
    if ($keyboard) {
        $url .= "&reply_markup=".json_encode($keyboard);
    }
    file_get_contents($url);
}

?>
